#version 330
#extension GL_EXT_gpu_shader4 : enable
//Rave SpiralMod01.fsh  by  daeken

//https://www.shadertoy.com/view/4ssXW7
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/* Compiled with Shaderforth: https://github.com/daeken/Shaderforth
:globals
	@vec3 uniform =iResolution
	@float uniform =iTime
	@vec4 uniform =iDate
;
:m time iDate .w ;
:m mtime iTime ;

:m circle ( p r )
	p length r -
;
:m box ( p d )
	( p abs d - 0 max length )
	p abs d - =t
		t \max 0 min
		t 0 max length
	+
;
:m roundbox ( p r d )
	 p d box r -
;

:m intersect \max ;
:m union \min ;
:m subtract \{ neg max } ;

:m repeat! ( p c ) p c mod .5 c * - ;
:m repeat ( f p c ) p c repeat! *f ;
:m scale ( f p s ) p s / *f s length * ;
:m rotate-cart ( f p a ) p a rotate-2d *f ;
:m rotate ( f p a ) p [ a 0 ] + polar-norm *f ;

: distance-field ( p:vec2 -> vec4 )
	p .y mtime 10 / p .y mtime + + sin 2 * * =a
	{ ( tp )
		{ ( rp )
			p [ a 0 ] + rp - logpolar->cart =xp
			[
						rp
						tau 40 /
					box
						rp
						tau 40 /
					circle
					xp .y 10 * sin abs
				mix
				[
					xp .y xp .x + 10 * sin 360 * abs
					xp .x 17 * sin abs
					xp .y 13 * sin abs
				] hsv->rgb
			]
		} tp tau 20 / repeat
	} p mtime - a rotate
;

:m texture ( d p )
	p distance-field .yzw =mat
	[ d neg 20 * 0 1 clamp mat * ]
;

iResolution frag->position cart->logpolar =p
[ p { distance-field .x } gradient p texture 1 ] =fragColor
*/

vec2 cart_logpolar(vec2 p) {
	return vec2(atan((p).y, (p).x), log(length(p)));
}
vec3 hsv_rgb(vec3 hsv) {
	return (mix(vec3(1.0, 1.0, 1.0), clamp((abs((mod((((hsv).x) / 60.0) + (vec3(0.0, 4.0, 2.0)), 6.0)) - 3.0)) - 1.0, 0.0, 1.0), (hsv).y)) * ((hsv).z);
}
vec2 polar_norm(vec2 p) {
	return vec2(mod(((p).x) + 6.28318, 6.28318), (p).y);
}
vec2 logpolar_cart(vec2 p) {
	return (vec2(cos((p).x), sin((p).x))) * (pow(2.71828, (p).y));
}
vec4 distance_field(vec2 p) {
	float a = ((p).y) * ((sin(((iTime) / 10.0) + (((p).y) + (iTime)))) * 2.0);
	vec2 xp = logpolar_cart(((p) + (vec2(a, 0.0))) - ((mod(polar_norm(((p) - (iTime)) + (vec2(a, 0.0))), 0.314159)) - 0.1570795));
	vec2 t = (abs((mod(polar_norm(((p) - (iTime)) + (vec2(a, 0.0))), 0.314159)) - 0.1570795)) - 0.1570795;
	return vec4(mix((min(max((t).x, (t).y), 0.0)) + (length(max(t, 0.0))), (length((mod(polar_norm(((p) - (iTime)) + (vec2(a, 0.0))), 0.314159)) - 0.1570795)) - 0.1570795, abs(sin(((xp).y) * 10.0))), hsv_rgb(vec3(abs((sin((((xp).y) + ((xp).x)) * 10.0)) * 360.0), abs(sin(((xp).x) * 17.0)), abs(sin(((xp).y) * 13.0)))));
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{
	vec2 p = cart_logpolar((((((gl_FragCoord).xy) / ((iResolution).xy)) * 2.0) - 1.0) * (vec2(1.0, ((iResolution).y) / ((iResolution).x))));
	vec2 h = vec2(0.001, 0.0);
	vec3 mat = (distance_field(p)).yzw;
	gl_FragColor = vec4(vec3((clamp((- (((distance_field(p)).x) / (abs(length((vec2(((distance_field((p) + (h))).x) - ((distance_field((p) - (h))).x), ((distance_field((p) + ((h).yx))).x) - ((distance_field((p) - ((h).yx))).x))) / (2.0 * ((h).x))))))) * 20.0, 0.0, 1.0)) * (mat)), 1.0);
}
